#!/bin/sh

mkdir -p ~/tmp ~/codes ~/soft ~/bentoml ~/notebooks ~/x ~/j \
      ~/.local/bin ~/.config ~/.local/dockerspace/gpu-devbox ~/.local/dockerspace/cpu-devbox

MINRC=$(cat <<EOF
# minimal rc

PATH=\$HOME/.bin.local:\$HOME/.bin:\$HOME/.local/bin:/opt/local/bin:/opt/local/sbin:/usr/local/bin:\$PATH

export LC_ALL=en_US.UTF-8
export LANG=en_US.UTF-8
export LANGUAGE=en_US.UTF-8

alias diru='du -h -d 1'

alias ca='docker exec -it -u larme cpu-devbox bash -l'
alias ga='docker exec -it -u larme gpu-devbox bash -l'
EOF
     )
echo "$MINRC" > ~/.min.rc
echo ". ~/.min.rc" >> ~/.bashrc

TMUXCONF=$(cat <<EOF
unbind 1
unbind 2
unbind 3
bind 1 resize-pane -Z
bind 2 split-window
bind 3 split-window -h
set -g default-terminal "screen-256color"
set-option -g default-command 'command -v reattach-to-user-namespace >/dev/null && exec reattach-to-user-namespace -l "$SHELL" || exec "$SHELL"'

set-option -g mouse on
bind-key -T root WheelUpPane if-shell -F -t = "#{alternate_on}" "send-keys -M" "select-pane -t =; copy-mode -e; send-keys -M"
bind-key -T root WheelDownPane if-shell -F -t = "#{alternate_on}" "send-keys -M" "select-pane -t =; send-keys -M"
EOF
     )
echo "$TMUXCONF" > ~/.tmux.conf

MGCONF=$(cat <<EOF
backup-to-home-directory
global-set-key "\^j\^o" switch-to-buffer
global-set-key "\^j\^f" find-file
global-set-key "\^j\^r" execute-extended-command
global-set-key "\ez" undo
EOF
     )
echo "$MGCONF" > ~/.mg
