import threading
import time

class SleeperThread(threading.Thread):
    def __init__(self, sleep_interval):
        super().__init__()
        self.sleep_interval = sleep_interval
        self.stop_event = threading.Event()

    def run(self):
        while not self.stop_event.is_set():
            # Do task here
            time.sleep(self.sleep_interval)

    def stop(self):
        self.stop_event.set()


Usage:

python

thread = SleeperThread(30) # sleep 30 seconds
thread.start()

# To stop thread
thread.stop()